\name{areaovate}
\encoding{UTF-8}
\alias{areaovate}
\title{
Area Calculation for an Ovate Polygon
}
\description{
\code{areaovate} is used to calculate the area of an ovate polygon made 
from combing two symmetrical curves generated by a performance equation (e.g., \code{\link{MLRFE}}).
}
\usage{
areaovate(expr, P, simpver = NULL,  
          subdivisions = 100L,
          rel.tol = .Machine$double.eps^0.25, 
          abs.tol = rel.tol, stop.on.error = TRUE, 
          keep.xy = FALSE, aux = NULL)
}
\arguments{
  \item{expr}{a performance equation or one of its simplified versions.}
  \item{P}{the parameters of the performance equation or one of its simplified versions.}
  \item{simpver}{an optional argument to use the simplfied version of the performance equation.}
  \item{subdivisions}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{rel.tol}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{abs.tol}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{stop.on.error}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{keep.xy}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
  \item{aux}{please see the arguments for the \code{\link{integrate}} function in package \pkg{stats}.}
}
\details{
The performance equations denote \code{\link{MbetaE}}, \code{\link{MBriereE}}, 
\code{\link{MLRFE}}, and their simplified versions. 
The arguments of \code{P} and \code{simpver} should correspond 
to \code{expr} (i.e., \code{\link{MbetaE}} or \code{\link{MBriereE}} or \code{\link{MLRFE}}). 
}
\value{
The area of two symmetrical curves along the \eqn{x}-axis 
generated by a performance equation or one of its simplified versions.
}
\note{
Here, the user can define other performance equations, but new equations or 
their simplified versions should include the lower and upper thresholds in 
the \eqn{x}-axis corresponding to \eqn{y = 0}, whose indices should 
be the same as those in \code{\link{MbetaE}} or \code{\link{MBriereE}} or \code{\link{MLRFE}}.
}
\author{
Peijian Shi \email{pjshi@njfu.edu.cn}, Johan Gielis \email{johan.gielis@uantwerpen.be}, 
Brady K. Quinn \email{Brady.Quinn@dfo-mpo.gc.ca}.
}
\references{
Jin, J., Quinn, B.K., Shi, P. (2022) The modified Brière equation and its 
applications. \emph{Plants} 11, 1769. \doi{10.3390/plants11131769}

Shi, P., Fan, M., Ratkowsky, D.A., Huang, J., Wu, H., Chen, L., Fang, S., 
Zhang, C. (2017) Comparison of two ontogenetic growth equations for animals and plants. 
\emph{Ecological Modelling} 349, 1\eqn{-}10. \doi{10.1016/j.ecolmodel.2017.01.012}

Shi, P., Gielis, J., Quinn, B.K., Niklas, K.J., Ratkowsky, D.A., Schrader, J., Ruan, H., 
Wang, L., Niinemets, Ü. (2022) 'biogeom': An R package for simulating and fitting natural 
shapes. \emph{Annals of the New York Academy of Sciences} 1516, 123\eqn{-}134. \doi{10.1111/nyas.14862}

Shi, P., Yu, K., Niklas, K.J., Schrader, J., Song, Y., Zhu, R., Li, Y., Wei, H., Ratkowsky, D.A. (2021)  
A general model for describing the ovate leaf shape. \emph{Symmetry} 13, 1524. \doi{10.3390/sym13081524}
}
\seealso{
\code{\link{curveovate}}, \code{\link{fitovate}}, \code{\link{MbetaE}}, \code{\link{MBriereE}}, 
\code{\link{MLRFE}}, \code{\link{MPerformanceE}}, \code{\link{sigmoid}}
}
\examples{
Par1 <- c(1.8175, 2.7795, 7.1557, 1.6030)
areaovate(MbetaE, P = Par1, simpver = 1)

Par2 <- c(0.0550, 0.3192, 7.1965, 0.5226)
areaovate(MBriereE, P = Par2, simpver = 1)

Par3 <- c(1.8168, 2.7967, 7.2623, 0.9662)
areaovate(MLRFE, P = Par3, simpver = 1)

Par4 <- c(2.4, 0.96, 0.64, 7.75, 1.76, 3.68)
areaovate(MPerformanceE, P = Par4, simpver = 1)
}