% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossNN.R
\name{crossNN}
\alias{crossNN}
\title{Compute cross-type nearest neighbor distances}
\usage{
crossNN(dist, n1, n2, w = rep(1, n1 + n2))
}
\arguments{
\item{dist}{a distance matrix, the upper n1 x n1 part contains distances between objects of type 1
the lower n2 x n2 part contains distances between objects of type 2}

\item{n1}{numbers of objects of type 1}

\item{n2}{numbers of objects of type 2}

\item{w}{optional weights of the objects (length n1+n2), defaults to equal weights}
}
\value{
a (n1+n2) x 2 matrix with the cross-type nearest neighbor distances and 
			weights given as the sum of the weights of the involved objects
}
\description{
Compute cross-type nearest neighbor distances
}
\author{
Fabian Scheipl
}

