% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metselaar_model.R
\name{dMetselaar_model}
\alias{dMetselaar_model}
\title{First Derivate of the Metselaar Model}
\usage{
dMetselaar_model(t, x, parms, temp_profile)
}
\arguments{
\item{t}{numeric vector indicating the time of the experiment.}

\item{x}{list with the value of N at t.}

\item{parms}{parameters for the secondary model. No explicit check of their validity
is performed (see section \bold{Model Parameters}).}

\item{temp_profile}{a function that provides the temperature at a given time.}
}
\value{
The value of the first derivative of N at time \code{t} as a list.
}
\description{
Calculates the first derivative of Metselaar model at a given time for
the model parameters provided and the environmental conditions given.
}
\details{
The model is developed from the isothermal Metselaar model without
taking into
account in the derivation the time dependence of \eqn{\delta_T} for
non-isothermal temperature profiles.

This function is compatible with the function
\code{\link{predict_inactivation}}.
}
\section{Model Equation}{


     \deqn{\frac{dN}{dt} = -N \cdot p \cdot (1/D)^p \cdot (t/Delta)^{p-1} }{
           dN/dt = -N * p * (1/D)^p * (t/Delta)^(p-1)}

     \deqn{D(T) = D_{ref} \cdot 10^{- (T-T_ref)/z} }{
           D(T) = D_R * 10^(- (T-T_ref)/z )}
}

\section{Model Parameters}{

     \itemize{
         \item temp_ref: Reference temperature for the calculation.
         \item D_R: D-value at the reference temperature.
         \item z: z-value.
         \item p: shape factor of the Weibull distribution.
         \item Delta: Scaling parameter
         }
}

\section{Note}{

     For t=0, dN = 0 unless n=1. Hence, a small shift needs to be introduced
     to t.
}

\seealso{
\code{\link{predict_inactivation}}
}
