% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/listDatabases.R
\name{listDatabases}
\alias{listDatabases}
\title{Retrieve a List of Available Databases for Download}
\usage{
listDatabases(db_name = "nr", db_format = "fasta", update = FALSE)
}
\arguments{
\item{db_name}{a character string specifying the name of the database that shall be searched for.}

\item{db_format}{a character string specifying the database format, e.g. \code{db_format} = \code{"fasta"}.}

\item{update}{a logical value specifying whether or not the local listDatabases.txt file shall be updated by remote access to NCBI.}
}
\description{
This function allows you to retrieve a list of database names and versions
that can be downloaded from correspondning servers.
}
\examples{
# retrieve all versions of the NCBI 'nr' database that can be downloaded
listDatabases(db_name = "nr", db_format = "fasta")

# analogous:
# listDatabases(db_name = "cdd", db_format = "fasta")
# listDatabases(db_name = "nt", db_format = "fasta")
# listDatabases(db_name = "gss", db_format = "fasta")
# listDatabases(db_name = "refseq_protein", db_format = "fasta")
}
\author{
Hajk-Georg Drost
}
\references{
\url{ftp://ftp.ncbi.nlm.nih.gov/blast/db/FASTA}
}
\seealso{
\code{\link{download_database}}
}

