% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listMetaGenomes.R
\name{listMetaGenomes}
\alias{listMetaGenomes}
\title{List available metagenomes on NCBI Genbank}
\usage{
listMetaGenomes(details = FALSE)
}
\arguments{
\item{details}{a boolean value specifying whether only the scientific names of stored metagenomes shall be returned
(\code{details = FALSE}) or all information such as "organism_name","bioproject", etc (\code{details = TRUE}).}
}
\description{
List available metagenomes on NCBI genbank. NCBI genbank allows users
to download entire metagenomes of several metagenome projects. This function lists
all available metagenomes that can then be downloaded via \code{\link{getMetaGenomes}}.
}
\examples{
\dontrun{
# retrieve available metagenome projects at NCBI Genbank
listMetaGenomes()

# retrieve detailed information on available metagenome projects at NCBI Genbank
listMetaGenomes(details = TRUE)
} 
}
\seealso{
\code{\link{getMetaGenomes}}, \code{\link{getMetaGenomeSummary}}
}
\author{
Hajk-Georg Drost
}
