% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_PlotResponseCurves.R
\name{bm_PlotResponseCurves}
\alias{bm_PlotResponseCurves}
\title{Plot response curves}
\usage{
bm_PlotResponseCurves(
  bm.out,
  models.chosen = "all",
  new.env = get_formal_data(bm.out, "expl.var"),
  show.variables = get_formal_data(bm.out, "expl.var.names"),
  fixed.var = "mean",
  do.bivariate = FALSE,
  do.plot = TRUE,
  do.progress = TRUE,
  ...
)
}
\arguments{
\item{bm.out}{a \code{\link{BIOMOD.models.out}} or \code{\link{BIOMOD.ensemble.models.out}} 
object that can be obtained with the \code{\link{BIOMOD_Modeling}} or 
\code{\link{BIOMOD_EnsembleModeling}} functions}

\item{models.chosen}{a \code{vector} containing model names to be kept, must be either 
\code{all} or a sub-selection of model names that can be obtained with the 
\code{\link{get_built_models}} function}

\item{new.env}{a \code{matrix}, \code{data.frame} or 
\code{\link[terra:rast]{SpatRaster}} object containing the new explanatory
 variables (in columns or layers, with names matching the variables names
 given to the \code{\link{BIOMOD_FormatingData}} function to build
 \code{bm.out}) that will be used to project the species distribution model(s)
\cr \emph{Note that old format from \pkg{raster} are still supported such as 
\code{RasterStack} objects. }}

\item{show.variables}{a \code{vector} containing the names of the explanatory variables 
present into \code{new.env} parameter and to be plotted}

\item{fixed.var}{a \code{character} corresponding to the statistic to be used to fix as 
constant the remaining variables other than the one used to predict response, must be either 
\code{mean}, \code{median}, \code{min}, \code{max}}

\item{do.bivariate}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether the response curves are to be represented in 3 
dimensions (meaning 2 explanatory variables at a time) or not (meaning only 1)}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the plot is to be rendered or not}

\item{do.progress}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the progress bar is to be rendered or not}

\item{\ldots}{some additional arguments (see Details)}
}
\value{
A \code{list} containing a \code{data.frame} with variables and predicted values and the 
corresponding \code{ggplot} object representing response curves.
}
\description{
This function represents response curves of species distribution models, from 
\code{\link{BIOMOD.models.out}} or \code{\link{BIOMOD.ensemble.models.out}} objects that can 
be obtained from \code{\link{BIOMOD_Modeling}} or \code{\link{BIOMOD_EnsembleModeling}} 
functions. Response curves can be represented in either 2 or 3 dimensions (meaning 1 or 2 
explanatory variables at a time, see Details).
}
\details{
This function is an adaptation of the Evaluation Strip method proposed by Elith et al. (2005). 
To build the predicted response curves :
\itemize{
  \item \code{n-1} variables are set constant to a fixed value determined by the 
  \code{fixed.var} parameter (in the case of categorical variable, the most represented 
  class is taken)
  \item the remaining variable is made to vary throughout its range given by the \code{new.env} 
  parameter 
  \item predicted values are computed with these \code{n-1} fixed variables, and this 
  studied variable varying 
}
If \code{do.bivariate = TRUE}, 2 variables are varying at the same time. \cr \cr

The response curves obtained show the sensibility of the model to the studied variable. \cr 
Note that this method does not account for interactions between variables. \cr \cr

\code{...} can take the following values :

\itemize{
  \item \code{main} : a \code{character} corresponding to the graphic title
}
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

# ---------------------------------------------------------------#
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl,
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      CV.strategy = 'random',
                                      CV.nb.rep = 2,
                                      CV.perc = 0.8,
                                      OPT.strategy = 'bigboss',
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      seed.val = 42)
}


# ---------------------------------------------------------------#
# Represent response curves
mods <- get_built_models(myBiomodModelOut, run = 'RUN1')
bm_PlotResponseCurves(bm.out = myBiomodModelOut, 
                      models.chosen = mods,
                      fixed.var = 'median')
## fixed.var can also be set to 'min', 'max' or 'mean'
# bm_PlotResponseCurves(bm.out = myBiomodModelOut, 
#                       models.chosen = mods,
#                       fixed.var = 'min')

# Bivariate case (one model)
# variables can be selected with argument 'show.variables'
# models can be selected with argument 'models.chosen'
mods <- get_built_models(myBiomodModelOut, full.name = 'GuloGulo_allData_RUN2_RF')
bm_PlotResponseCurves(bm.out = myBiomodModelOut, 
                      show.variables = c("bio4","bio12","bio11"),
                      models.chosen = mods,
                      fixed.var = 'median',
                      do.bivariate = TRUE)
                                      
                                      
}
\references{
\itemize{
  \item Elith, J., Ferrier, S., Huettmann, FALSE. and Leathwick, J. R. 2005. The evaluation 
  strip: A new and robust method for plotting predicted responses from species distribution 
  models. \emph{Ecological Modelling}, \bold{186}, 280-289.
}
}
\seealso{
\code{\link{BIOMOD.models.out}}, \code{\link{BIOMOD.ensemble.models.out}}, 
\code{\link{BIOMOD_Modeling}}, \code{\link{BIOMOD_EnsembleModeling}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}

Other Plot functions: 
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotVarImpBoxplot}()}
}
\author{
Damien Georges, Maya Gueguen
}
\concept{Plot functions}
\concept{Secundary functions}
\keyword{curve}
\keyword{ggplot}
\keyword{response}
