% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeFilter.R
\name{sizeFilter}
\alias{sizeFilter}
\title{Size-based exclusion}
\usage{
sizeFilter(centers, coordinates, lowerlimit = "auto", upperlimit = "auto")
}
\arguments{
\item{centers}{center coordinates of objects (needs to include 'value'
representing the center number)}

\item{coordinates}{all coordinates of the objects (x|y|value data frame)}

\item{lowerlimit}{smallest accepted object size (when 'auto' both limits are
calculated by using the mean and the standard deviation)}

\item{upperlimit}{highest accepted object size}
}
\value{
list of 3 objects:
\enumerate{
\item remaining centers after discarding according to size
\item remaining coordinates after discarding according to size
\item size of remaining objects
}
}
\description{
Calculates the size of the objects in an image and discards objects based
on a lower and an upper size limit. (Input can be obtained by objectDetection function)
}
\examples{
res_objectDetection <- objectDetection(beads, alpha = 1, sigma = 2)
res_sizeFilter <- sizeFilter(
  centers = res_objectDetection$centers,
  coordinates = res_objectDetection$coordinates,
  lowerlimit = 50, upperlimit = 150
  )
changePixelColor(
  beads,
  res_sizeFilter$coordinates,
  color = "darkgreen",
  visualize = TRUE
  )
}
