% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changePixelColor.R
\name{changePixelColor}
\alias{changePixelColor}
\title{Change the color of pixels}
\usage{
changePixelColor(img, coordinates, color = "purple", visualize = FALSE)
}
\arguments{
\item{img}{image (import by \code{\link[biopixR]{importImage}})}

\item{coordinates}{specifying which pixels to be colored (should
be a x|y data frame).}

\item{color}{color to be applied to specified pixels:
\itemize{
\item color from the list of colors defined by \code{\link[grDevices]{colors}}
\item object of class factor
}}

\item{visualize}{if TRUE the resulting image gets plotted}
}
\value{
Object of class 'cimg' with changed colors at desired positions.
}
\description{
The function allows the user to alter the color of a specified set of pixels
within an image. In order to achieve this, the coordinates of the pixels in
question must be provided.
}
\examples{
coordinates <-
  objectDetection(beads,
                  method = 'edge',
                  alpha = 1,
                  sigma = 0)
changePixelColor(
  beads,
  coordinates$coordinates,
  color = factor(coordinates$coordinates$value),
  visualize = TRUE
)
}
\references{
https://CRAN.R-project.org/package=countcolors
}
