% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_kmeans.R
\name{nhclu_kmeans}
\alias{nhclu_kmeans}
\title{Non hierarchical clustering: k-means analysis}
\usage{
nhclu_kmeans(
  dissimilarity,
  index = names(dissimilarity)[3],
  n_clust = NULL,
  iter_max = 10,
  nstart = 10,
  algorithm = "Hartigan-Wong"
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns represent pairs of sites (or any pair of nodes),
and the next column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{n_clust}{an \code{integer} or a \code{vector} of \code{integers} specifying the
requested number(s) of clusters}

\item{iter_max}{an \code{integer} specifying the maximum number of
iterations for the kmeans method (see \link[stats:kmeans]{stats::kmeans()})}

\item{nstart}{an \code{integer} specifying how many random sets of
\code{n_clust} should be selected as starting points for the kmeans analysis
(see \link[stats:kmeans]{stats::kmeans()})}

\item{algorithm}{a \verb{character string} specifying the algorithm to use for
kmean (see \link[stats:kmeans]{stats::kmeans()}). Available options are
Hartigan-Wong, Lloyd, Forgy and MacQueen.}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \verb{character string} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}
}
\description{
This function performs non hierarchical
clustering on the basis of dissimilarity with a k-means analysis.
}
\details{
This method partitions the data into k groups
such that that the sum of squares of euclidean distances from points to the
assigned cluster centers is minimized. k-means cannot be applied directly
on dissimilarity/beta-diversity metrics, because these distances are not
euclidean. Therefore, it requires first to transform the dissimilarity
matrix with a Principal Coordinate Analysis (using the function
\link[ape:pcoa]{ape::pcoa()}), and then applying k-means on the coordinates
of points in the PCoA. Because this makes an additional transformation of
the initial matrix of dissimilarity, the partitioning around medoids method
should be preferred (\code{\link[=nhclu_pam]{nhclu_pam()}})
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

comnet <- mat_to_net(comat)

dissim <- dissimilarity(comat, metric = "all")

clust1 <- nhclu_kmeans(dissim, n_clust = 2:10, index = "Simpson")
clust2 <- nhclu_kmeans(dissim, n_clust = 2:15, index = "Simpson")
partition_metrics(clust2, dissimilarity = dissim,
                  eval_metric = "pc_distance")

partition_metrics(clust2, net = comnet, species_col = "Node2",
                  site_col = "Node1", eval_metric = "avg_endemism")

}
\seealso{
\link{nhclu_pam}

\link{cut_tree}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
