% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_clara.R
\name{nhclu_clara}
\alias{nhclu_clara}
\title{Non hierarchical clustering: CLARA}
\usage{
nhclu_clara(
  dissimilarity,
  index = names(dissimilarity)[3],
  n_clust = NULL,
  maxiter = 0L,
  initializer = "LAB",
  fasttol = 1,
  numsamples = 5L,
  sampling = 0.25,
  independent = FALSE,
  seed = 123456789L
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns represent pairs of sites (or any pair of nodes),
and the next column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{n_clust}{an \code{integer} or a \code{vector} of \code{integers} specifying the
requested number(s) of clusters.}

\item{maxiter}{an \code{integer} defining the maximum number of iterations.}

\item{initializer}{character string, either 'BUILD' (used in classic PAM
algorithm) or 'LAB' (linear approximative BUILD).}

\item{fasttol}{Positive numeric defining the tolerance for fast swapping
behavior, set to 1 by default.}

\item{numsamples}{Positive integer defining the number of samples to draw.}

\item{sampling}{Positive numeric defining the sampling rate.}

\item{independent}{Logical, FALSE by default meaning that the previous
medoids are not kept in the next sample.}

\item{seed}{an \code{integer} to define a generator of random numbers.}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \verb{character string} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}
}
\description{
This function performs non hierarchical clustering on the basis of
dissimilarity with partitioning around medoids, using the Clustering Large
Applications (CLARA) algorithm.
}
\details{
Based on fastkmedoids R package.
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

dissim <- dissimilarity(comat, metric = "all")

clust1 <- nhclu_clara(dissim, index = "Simpson", n_clust = 5)

partition_metrics(clust1, dissimilarity = dissim,
eval_metric = "pc_distance")

   
}
\references{
\insertRef{Schubert2019}{bioregion}
}
\seealso{
\link{nhclu_pam}
}
\author{
Pierre Denelle (\email{pierre.denelle@gmail.com}),
Boris Leroy (\email{leroy.boris@gmail.com}), and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
