% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_stat_operations.R
\name{seq_stat_prop}
\alias{seq_stat_prop}
\title{Compute proportions for characters}
\usage{
seq_stat_prop(x, gaps = FALSE)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{gaps}{if \code{FALSE} gaps are ignored.}
}
\value{
A list of vectors indicating the
proportion of characters in each sequence.
}
\description{
Compute proportions for characters
}
\examples{

x <- dna(c("ATGCAGA", "GGR-----","TTGCCTAGKTGAACC"))
seq_stat_prop(x)
seq_stat_prop(x, gaps = TRUE)

}
\seealso{
Other op-misc: \code{\link{seq_disambiguate_IUPAC}},
  \code{\link{seq_nchar}}, \code{\link{seq_nseq}},
  \code{\link{seq_spellout}}, \code{\link{seq_stat_gc}}
}
\concept{op-misc}
