% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_calc_variability}
\alias{set_calc_variability}
\title{Calculate parameters of variability for a given set of values.}
\usage{
set_calc_variability(data, ids, ...)
}
\arguments{
\item{data}{A tibble containing the data.}

\item{ids}{The column holding the names used to group the values.}

\item{...}{The name(s) of the columns used to calculate the variability.}
}
\value{
A tibble containing all original and additional columns
(NAMEA_mean, NAMEA_n, NAMEA_sd, NAMEA_cv, (NAMEB_mean, ...)).
}
\description{
Calculate mean, standard deviation and coefficient of variation for groups of
values.
}
\details{
Dealing with measured values, the measurement of sample "A" is often done in
duplicates / triplicates / ... . This function groups all samples with the
same name and calculates mean, standard deviation and coefficient of
variation (= sd / mean).
}
\examples{
# generate data
library("tibble")

data <- tibble(
  names = c("A", "B", "C", "A", "B", "C"),
  value = c(19, 59, 22, 18, 63, 28),
  conc = c(1.9, 5.9, 2.2, 1.8, 6.3, 2.8)
)

data

set_calc_variability(
  data = data,
  ids = names,
  value,
  conc
)

# to set column names use notation like in dplyr / tidyverse
\dontrun{
# notice how strings are given as column names
set_calc_variability(
  data = data,
  ids = "names",
  "value",
  "conc"
)
}

rm(cals)

}
\seealso{
Other set functions: \code{\link{set_calc_concentrations}},
  \code{\link{set_read}}
}
