% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical_data.R
\name{clinical_data}
\alias{clinical_data}
\title{Simulate Simple Clinical Trial Data}
\usage{
clinical_data(
  n = 100,
  visits = 3,
  arms = c("Placebo", "Treatment"),
  dropout = 0,
  missing = 0
)
}
\arguments{
\item{n}{Integer indicating the number (1-999) of participants. Default: 100.}

\item{visits}{Integer indicating the number of visits including baseline. Default: 3.}

\item{arms}{Character vector of treatment arm names. Default: c("Placebo", "Treatment").}

\item{dropout}{Numeric parameter indicating the proportion (0-1) of participants. who dropout. Default: 0.}

\item{missing}{Numeric parameter indicating the proportion (0-1) of missing values to be introduced
across numeric variables with fixed proportions (biomarker = 15\%, weight = 25\%, response = 60\%). Default: 0.}
}
\value{
Dataframe with columns: participant_id, visit, sex, treatment, age,
weight, biomarker, and response in long format.
}
\description{
Creates a simple simulated clinical trial dataset with participant demographics,
multiple visits, treatment groups with different effects, numerical and
categorical variables, as well as optional missing data and dropout rates.
}
\examples{
# Basic dataset
clinical_df <- clinical_data()

# Multiple treatment arms with dropout rate and missing data
clinical_df <- clinical_data(arms = c('Placebo', 'A', 'B'), missing = 0.05, dropout = 0.10)

}
