% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_data_EG.R
\name{explore_data_EG}
\alias{explore_data_EG}
\title{Plots to explore environmental factors in environmental and geographic space}
\usage{
explore_data_EG(master, variable_1, variable_2, region_border = TRUE,
                mask_border = FALSE, col_variable1 = NULL,
                col_variable2 = NULL, col_points = NULL, col_density = NULL)
}
\arguments{
\item{master}{master_matrix object derived from function
\code{\link{prepare_master_matrix}} or master_selection object derived from
functions \code{\link{uniformG_selection}}, \code{\link{uniformE_selection}}
or \code{\link{EG_selection}}.}

\item{variable_1}{(character or numeric) name or position of the first
variable (x-axis) to be explored.}

\item{variable_2}{(character or numeric) name or position of the second
variable (y-axis) to be explored (must be different from the first one).}

\item{region_border}{(logical) whether to add region border to the plot.
Default = TRUE.}

\item{mask_border}{(logical) whether to add mask border to the plot. Ignored
if mask is not present in \code{master_selection}. Default = FALSE.}

\item{col_variable1}{a color palette for \code{variable_1} defined
using functions like \code{\link{heat.colors}}, or one generated
using functions like \code{\link{colorRampPalette}}. The default,
NULL, uses a colorblind friendly palette similar to viridis.}

\item{col_variable2}{a color palette for \code{variable_2} defined
using functions like \code{\link{heat.colors}}, or one generated
using functions like \code{\link{colorRampPalette}}. The default,
NULL, uses a colorblind friendly palette similar to viridis.}

\item{col_points}{color for points in environmental space. The default, NULL,
uses the 25th color of the default palette for \code{col_variable1} with an
alpha of 0.6.}

\item{col_density}{color palette to represent representation density of
points in environmental space. This palette can be defined using functions
like \code{\link{heat.colors}}, or one generated using functions like
\code{\link{colorRampPalette}}. The default, NULL, uses a colorblind
friendly palette similar to magma, and changes the first color in the palette
to NA.}
}
\value{
A multi-panel plot showing two of the environmental predictors in the region
of interest in both spaces, geographic and environmental.
}
\description{
Creates a four-panel plot with information of two environmental
predictors (at a time) in the region of interest (or region reduced with mask,
if used). The two top panels contain the information in geographic space (one
predictor per panel). The two panels at the bottom contain information in a
2D environmental space for the two variables.
}
\examples{
# Data
data("m_matrix", package = "biosurvey")

colnames(m_matrix$data_matrix)

# Plot
\donttest{
explore_data_EG(m_matrix, variable_1 = "Mean_temperature",
                variable_2 = "Annual_precipitation")
}
}
