% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_selection.R
\name{random_selection}
\alias{random_selection}
\title{Random selection of survey sites}
\usage{
random_selection(master, n_sites, n_samplings = 1,
                 use_preselected_sites = TRUE, median_distance_filter = NULL,
                 set_seed = 1, verbose = TRUE, force = FALSE)
}
\arguments{
\item{master}{master_matrix object derived from function
\code{\link{prepare_master_matrix}}, or master_selection object derived
from functions \code{\link{uniformG_selection}},
\code{\link{uniformE_selection}} or \code{\link{EG_selection}}.}

\item{n_sites}{(numeric) number of sites to be selected from
\code{master_matrix} to be used as sites to be sampled in survey.}

\item{n_samplings}{(numeric) number of processes of selection, which will
turn into multiple options for a process of survey planning. Default = 1.}

\item{use_preselected_sites}{(logical) whether to use sites that have been
defined as part of the selected sites previous to any selection. Object in
\code{master} must contain the site(s) preselected in and element of name
"preselected_sites" for this argument to be effective. Default = TRUE.}

\item{median_distance_filter}{(character) optional argument to define a
median distance-based filter based on which sets of sampling sites will be
selected. The default, NULL, does not apply such a filter. Options are:
"max" and "min".}

\item{set_seed}{(numeric) integer value to specify a initial seed.
Default = 1.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}

\item{force}{(logical) whether to replace existing set of sites selected
with this method in \code{master}.}
}
\value{
A \code{\link{master_selection}} object (S3) with an element
called selected_sites_random containing one or more sets of selected sites.
}
\description{
Random selection of sites to be sampled in a survey. Sites are
selected from a set of points provided in \code{master}.
}
\details{
Survey sites are selected randomly from the entire set of points provided in
\code{master$data_matrix}. Considering the environmental space, as points
are selected randomly, sites that have environmental conditions that are
common in the region of interest will be sampled more that other sites that
present condition that are not as common.

To see how common or rare are distinct environments in the region of
interest, the function \code{\link{explore_data_EG}} can be used. Common
environmental conditions are those that are present in areas of higher
density in one of the plots obtained with \code{\link{explore_data_EG}}.

As multiple sets could result from selection, the argument of the function
\code{median_distance_filter} could be used to select the set of sites with
the maximum ("max") or minimum ("min") median distance among selected sites.
Option "max" will increase the geographic distance among sampling sites,
which could be desirable if the goal is to cover the region of interest more
broadly. The other option, "min", could be used in cases when the goal is to
reduce resources and time needed to sample such sites.
}
\examples{
# Data
data("m_matrix", package = "biosurvey")

r_selection <- random_selection(m_matrix, n_sites = 20, n_samplings = 5)
}
\seealso{
\code{\link{uniformG_selection}}, \code{\link{uniformE_selection}},
\code{\link{EG_selection}}, \code{\link{plot_sites_EG}}
}
