% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_pam.R
\name{subset_PAM}
\alias{subset_PAM}
\title{Subset PAM according to selected sites}
\usage{
subset_PAM(base_PAM, master_selection, selection_type = "all")
}
\arguments{
\item{base_PAM}{object of class base_PAM obtained using the function
\code{\link{prepare_base_PAM}}.}

\item{master_selection}{object of class master_selection. This object can be
obtained using the functions: \code{\link{random_selection}},
\code{\link{uniformG_selection}}, \code{\link{uniformE_selection}}, or
\code{\link{EG_selection}}.}

\item{selection_type}{type of selection to be considered to subset
\code{base_PAM}. Options are: "all", "random", "E", "G", and "EG". The
default, "all", uses all selection types present in \code{master_selection}.}
}
\value{
An object of class \code{\link{PAM_subset}} containing the original
\code{base_PAM} and other subsets of the PAM according to
\code{selection_type}.
}
\description{
Subsets of a base_PAM object according to survey sites
contained in a master_selection object.
}
\examples{
# Data
data("b_pam", package = "biosurvey")
data("m_selection", package = "biosurvey")

# Subsetting base PAM according to selections
## only uniform in G
sub_pam_G <- subset_PAM(b_pam, m_selection, selection_type = "G")

## All at the time
sub_pam_all <- subset_PAM(b_pam, m_selection, selection_type = "all")
}
