% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_JS_Writer.R
\name{BP_JS_Writer}
\alias{BP_JS_Writer}
\title{Generate JavaScript file for a bipartite network}
\usage{
BP_JS_Writer(
  df,
  filename = "JSBP",
  colouroption = c("monochrome", "brewer", "manual")[1],
  HighlightLab = "Unlinked",
  HighlightCol = "#3366CC",
  monoChromeCol = "rgb(56,43,61)",
  ColourBy = c(1, 2)[2],
  BrewerPalette = "Accent",
  NamedColourVector,
  MainFigSize = NULL,
  SortPrimary = NULL,
  SortSecondary = NULL,
  mp = c(1, 1),
  MinWidth = 10,
  Pad = 1,
  IndivFigSize = c(200, 400),
  BarSize = 35,
  Orientation = c("vertical", "horizontal")[1],
  EdgeMode = c("straight", "smooth")[2],
  AxisLabels = NULL,
  FigureLabel = NULL,
  BoxLabPos = NULL,
  IncludePerc = TRUE,
  PercentageDecimals = 0,
  PercPos = NULL,
  CSS_Output_Supress = FALSE,
  PRINT = FALSE
)
}
\arguments{
\item{df}{data.frame containing the names of the interactors and the link strengths. bipartite package data need to be passed through Matrix2DF or Array2DF first.}

\item{filename}{character string to name the .js and .css files. Do not include a file extension}

\item{colouroption}{Either 'monochrome', 'brewer' or 'manual'}

\item{HighlightLab}{Name of interactor to highlight}

\item{HighlightCol}{Highlight colour}

\item{monoChromeCol}{If using monochrome option, what colour to use}

\item{ColourBy}{Which set of interactors to colour by. 1= primary, 2= secondary}

\item{BrewerPalette}{RColorBrewer palette}

\item{NamedColourVector}{Named vector of colours for manual colour assignment}

\item{MainFigSize}{Size of figure, used here to calculate facet spacing.}

\item{SortPrimary}{Vector detailing order to arrange primary level. Default is alphabetical}

\item{SortSecondary}{Vector detailing order to arrange secondary level. Default is alphabetical}

\item{mp}{Numeric vector c(rows, columns)}

\item{MinWidth}{Numeric. Minimum size to shrink unselected interactors to.}

\item{Pad}{Numeric. Gap between species.}

\item{IndivFigSize}{Size of each facet, specifically the interactions.}

\item{BarSize}{Thickness of bars representing interactors}

\item{Orientation}{Either 'horizontal' or 'vertical' orientation.}

\item{EdgeMode}{Set to 'straight' to avoid curly lines.}

\item{AxisLabels}{c('Primary','Secondary') to overide column names of dataframe}

\item{FigureLabel}{Character vector, to allow overide of use of df column names}

\item{BoxLabPos}{c(x_p,x_s) To adjust position of species labels. Default is based on maximum length of labels.}

\item{IncludePerc}{Boolean. whether or not to show percentage links}

\item{PercentageDecimals}{Number of decimal places to display percentages to. Useful if rare species are rounded to 0.}

\item{PercPos}{c(x_p,x_s) To adjust position of percentages.  Default is based on maximum length of labels.}

\item{CSS_Output_Supress}{Boolean. Set to TRUE if you have changed the CSS file manually and don't want it over written}

\item{PRINT}{Boolean. Output generated JavaScript to screen?}
}
\value{
As a side effect, saves visjs.js (vis plotting library), filename.js and filename.css to the working directory.
}
\description{
Function called by bipartite_D3() to write JavaScript and CSS file.
In most cases it is better to use bipartite_D3() directly.
}
\examples{

## Simple Data Set
testdata <- data.frame(higher = c("bee1","bee1","bee1","bee2","bee1","bee3"),
lower = c("plant1","plant2","plant1","plant2","plant3","plant4"),
 Meadow=c(5,9,1,2,3,7))

BP_JS_Writer(testdata,PRINT=TRUE)

## tidy up (to keep CRAN happy, not needed in real life use)
file.remove('vizjs.js')
file.remove('JSBP.js')
file.remove('JSBP.css')

}
