% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_theme.R
\name{bi_theme}
\alias{bi_theme}
\title{Basic Theme for Bivariate Mapping}
\usage{
bi_theme(
  base_family = "sans",
  base_size = 24,
  bg_color = "#ffffff",
  font_color = "#000000",
  ...
)
}
\arguments{
\item{base_family}{A character string representing the font family to be used in the map.}

\item{base_size}{A number representing the base size used in the map.}

\item{bg_color}{A character string containing the hex value for the desired color of the map's background.}

\item{font_color}{A character string containing the hex value for the desired color of the map's text.}

\item{...}{Arguments to pass on to \code{ggplot2}'s \code{theme} function}
}
\description{
A theme for creating a simple, clean bivariate map using \code{\link{ggplot2}}.
}
\examples{
# load suggested dependencies
library(ggplot2)
library(sf)

# add breaks, 3x3
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, dim = 3)

# create map
ggplot() +
  geom_sf(data = data, aes(fill = bi_class), color = "white", size = 0.1, show.legend = FALSE) +
  bi_scale_fill(pal = "GrPink", dim = 3) +
  bi_theme()

}
