% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{c.bm_bitmap}
\alias{c.bm_bitmap}
\alias{c.bm_font}
\alias{c.bm_list}
\title{Combine bitmap objects}
\usage{
\method{c}{bm_bitmap}(...)

\method{c}{bm_font}(...)

\method{c}{bm_list}(...)
}
\arguments{
\item{...}{\code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, and/or \code{\link[=bm_font]{bm_font()}} objects to combine.}
}
\value{
Either a \code{\link[=bm_list]{bm_list()}} or \code{\link[=bm_font]{bm_font()}} object.
See Details for more info.
}
\description{
\code{c()} combines bitmap objects into \code{bm_list()} or \code{bm_font()} objects.
In particular when using it to combine fonts the later fonts
"update" the glyphs in the earlier fonts.
}
\details{
The various bitmap objects are "reduced" in the following ways:
\tabular{lll}{
First \tab Second \tab Result\cr
\code{bm_bitmap()} \tab \code{bm_bitmap()} \tab \code{bm_list()}\cr
\code{bm_bitmap()} \tab \code{bm_list()} \tab \code{bm_list()}\cr
\code{bm_bitmap()} \tab \code{bm_font()} \tab \code{bm_font()}\cr
\code{bm_list()} \tab \code{bm_bitmap()} \tab \code{bm_list()}\cr
\code{bm_list()} \tab \code{bm_list()} \tab \code{bm_list()}\cr
\code{bm_list()} \tab \code{bm_font()} \tab \code{bm_font()}\cr
\code{bm_font()} \tab \code{fm_bitmap()} \tab \code{bm_font()}\cr
\code{bm_font()} \tab \code{fm_list()} \tab \code{bm_font()}\cr
\code{bm_font()} \tab \code{fm_font()} \tab \code{bm_font()}\cr
}
When combining with a \code{bm_font()} object if any \code{bm_bitmap()} objects
share the same name we only keep the last one.
Although names are preserved other attributes such as font
comments and properties are not guaranteed to be preserved.
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
capital_r <- font[[str2ucp("R")]]
stats <- as_bm_list("STATS", font = font)
is_bm_list(c(capital_r, capital_r))
rstats <- c(capital_r, stats)
print(bm_call(rstats, cbind), px = px_ascii)
}
