% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.bizday.R
\name{is.bizday}
\alias{is.bizday}
\title{Checks if the given dates are business days.}
\usage{
is.bizday(dates, cal)
}
\arguments{
\item{dates}{dates to be checked}

\item{cal}{the calendar's name}
}
\value{
\code{logical} objects informing that given dates are or are not business
days.
}
\description{
Returns \code{TRUE} if the given date is a business day and \code{FALSE}
otherwise.
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\examples{
is.bizday("2013-01-02", "Brazil/ANBIMA")

# Once you have a default calendar set, cal does not need to be provided
bizdays.options$set(default.calendar = "Brazil/ANBIMA")

dates <- seq(as.Date("2013-01-01"), as.Date("2013-01-05"), by = "day")
is.bizday(dates)
}
