% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zicreg-methods.R
\name{simulate.zicreg}
\alias{simulate.zicreg}
\title{Simulating response values from fitted univariate zero-inflated count
regression model}
\usage{
\method{simulate}{zicreg}(object, nsim = 250, seed = 123, ...)
}
\arguments{
\item{object}{A \code{\link{zicreg-class}} omodel bject, as returned by \code{\link{zic.reg}}.}

\item{nsim}{Number of simulated datasets to create.}

\item{seed}{Random seed for random number generation in simulations. If
\code{NULL}, no seed is set.}

\item{...}{Ignored.}
}
\value{
A numeric \eqn{n x nsim} matrix, with rows indexing
observations, and columns indexing the simulation number.
}
\description{
Simulates responses using the fitted parameters from a
\code{\link{zicreg-class}} object, as returned by \code{\link{zic.reg}}.
Primarily useful for methods found in \code{\link[DHARMa]{DHARMa}} package. See 'Examples.'
}
\examples{
# Simulate some zip data
n=1000
x = cbind(1, rnorm(n))
z = cbind(1, rbeta(n, 4, 8))
b = c(1, 2.2)
g = c(-1, 1.7)
lam = exp(x \%*\% b)
psi = plogis(z \%*\% g)

y = bizicount::rzip(n, lambda = lam, psi=psi)
dat = cbind.data.frame(x = x[,-1], z = z[,-1], y = y)

# estimate model

mod = zic.reg(y ~ x | z, data = dat, keep = TRUE)

# simulate from fit for use in dharma
sims = simulate(mod)

### Make dharma object

dharm = DHARMa::createDHARMa(
     simulatedResponse = sims,
     observedResponse = y,
     fittedPredictedResponse = fitted(mod),
     integerResponse = TRUE,
     method = "PIT"
)

### Plot the DHARMa object, do other diagnostics
plot(dharm)
DHARMa::testResiduals(dharm)
}
\references{
Florian Hartig (2022). DHARMa: Residual Diagnostics for
Hierarchical (Multi-Level / Mixed) Regression Models. R package version
0.4.5. https://CRAN.R-project.org/package=DHARMa
}
\author{
John Niehaus
}
