% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda_funs.R
\name{as.mcmc.bkmrfit}
\alias{as.mcmc.bkmrfit}
\title{Convert bkmrfit to mcmc object for coda MCMC diagnostics}
\usage{
\method{as.mcmc}{bkmrfit}(x, iterstart = 1, thin = 1, ...)
}
\arguments{
\item{x}{object of type kmrfit (from bkmr package)}

\item{iterstart}{first iteration to use (e.g. for implementing burnin)}

\item{thin}{keep 1/thin \% of the total iterations (at regular intervals)}

\item{...}{unused}
}
\value{
An \code{\link[coda]{mcmc}} object
}
\description{
Converts a \code{kmrfit} (from the bkmr package) into
an \code{\link[coda]{mcmc}} object from the \code{coda} package. The
\code{coda} package enables many different types of single chain MCMC
diagnostics, including \code{\link[coda]{geweke.diag}}, \code{\link[coda]{traceplot}} and
\code{\link[coda]{effectiveSize}}. Posterior summarization is also available,
such as \code{\link[coda]{HPDinterval}} and \code{\link[coda]{summary.mcmc}}.
}
\examples{

# following example from https://jenfb.github.io/bkmr/overview.html
 \donttest{
set.seed(111)
library(coda)
library(bkmr)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 5000, verbose = FALSE,
  varsel = FALSE)
mcmcobj <- as.mcmc(fitkm, iterstart=2501)
summary(mcmcobj) # posterior summaries of model parameters
# compare with default from bkmr package, which omits first 1/2 of chain
summary(fitkm)
# note this only works on multiple chains (see kmbayes_parallel)
# gelman.diag(mcmcobj)
# lots of functions in the coda package to use
traceplot(mcmcobj)
# will also fail with delta functions (when using variable selection)
try(geweke.plot(mcmcobj))
}
}
