% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blatentEstimate.R
\name{blatentEstimate}
\alias{blatentEstimate}
\title{Use blatent to estimate a Bayesian latent variable model. Currently supports estimation of the LCDM (Loglinar Cognitive
Diagnosis Model).}
\usage{
blatentEstimate(
  dataMat,
  modelText,
  priorsList = NULL,
  options = blatentControl()
)
}
\arguments{
\item{dataMat}{A data frame containing the data used for the analysis.}

\item{modelText}{A character string that contains the specifications for the model to be run. See \code{\link{blatentSyntax}}
or more information about syntax formatting.}

\item{priorsList}{A list of priors to be placed on parameters of the model. Defaults to NULL. Currently only accepts NULL.
All priors not set in \code{priorsList} will be set in options using \code{\link{blatentControl}} via the
\code{\link{setDefaultPriors}} function.}

\item{options}{A list of options for estimating the model. Use the \code{\link{blatentControl}} function to specify the options.
See \code{\link{blatentControl}} for more information and default values.}
}
\value{
A blatentModel object (an R6 class).
}
\description{
Blatantly runs Bayesian latent variable models.
}
