% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auxiliary_and_graphics_functions.R
\name{interpretation_plot}
\alias{interpretation_plot}
\title{interpretation_plot}
\usage{
interpretation_plot(data, Bliss_estimate, q = 1, centered = FALSE,
  cols = NULL)
}
\arguments{
\item{data}{a list containing:
\describe{
\item{y}{a numerical vector, the outcomes.}
\item{x}{a list of matrices, the qth matrix contains the observations of the
      qth functional covariate at time points given by \code{grids}.}
\item{grids}{a list of numerical vectors, the qth vector is the grid of
       time points for the qth functional covariate.}
}}

\item{Bliss_estimate}{a numerical vector, the Bliss estimate.}

\item{q}{an integer (optional), the index of the functional covariate to plot.}

\item{centered}{a logical value (optional), If TRUE, the functional data are centered.}

\item{cols}{a numerical vector of colours (optional).}
}
\description{
Provide a graphical representation of the functional data
             with a focus on the detected periods with the Bliss method.
}
\examples{
data(data1)
data(param1)
# result of res_bliss1 <- fit_Bliss(data=data1,param=param1,verbose=TRUE)
data(res_bliss1)
interpretation_plot(data=data1,Bliss_estimate=res_bliss1$Bliss_estimate,q=1)
interpretation_plot(data=data1,Bliss_estimate=res_bliss1$Bliss_estimate,q=1,centered=TRUE)
}
