% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blkboxPlot.R
\name{ncv.plot}
\alias{ncv.plot}
\title{Nested Crossfold Validation Performance Plot.}
\usage{
ncv.plot(obj, metric, y_ranges, title)
}
\arguments{
\item{obj}{An object produced by the blkboxCV function.}

\item{metric}{Which metric you wish to plot, can only plot those specified to the blkboxNCV function at time of running. Area under the Receiver operating curve = "AUROC", Accuracy = "ACC", Error rate = "ERR", Matthews correlation coefficient = "MCC", F-1 score = "F-1". Default is the first metric specified to your NCV arguments vector.}

\item{y_ranges}{is the y axis limits for the plot, defaults to c(0,1). Must be a numeric vector with two entries.}

\item{title}{the title to be adhered to the plot. Default is no title.}
}
\description{
Compares the performance of each algorithm in a boxplot. Each holdout will contribute at least one data point to each algorithms boxplot.
}
\examples{
\donttest{
ncv.plot(blkboxNCV(...), metric = "AUROC", title = "NCV Performance Boxplot")
}
}
\author{
Zachary Davies, Boris Guennewig
}
\keyword{NCV,}
\keyword{Plot,}
\keyword{boxplot}
\keyword{ggplot2,}

