% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.r
\name{blocks}
\alias{blocks}
\title{Block designs for unstructured treatment sets}
\usage{
blocks(
  treatments,
  replicates,
  blocks = NULL,
  searches = NULL,
  seed = NULL,
  jumps = 1
)
}
\arguments{
\item{treatments}{the required number of treatments partitioned into sets of equally replicated treatments.}

\item{replicates}{the treatment replication numbers for each partitioned treatment set.}

\item{blocks}{the number of nested blocks for each level of nesting from the top down.}

\item{searches}{the maximum number of local optima searched for a design optimization.}

\item{seed}{an integer initializing the random number generator.}

\item{jumps}{the number of pairwise random treatment swaps used to escape a local maxima.}
}
\value{
\item{Treatments}{A table showing the replication number of each treatment in the design.}
\item{Design}{Data frame giving the optimized block and treatment design in plot order.}
\item{Plan}{Data frame showing a plan view of the treatment design in the bottom level of the design.}
\item{Blocks_model}{The D-efficiencies and the A-efficiencies of the blocks in each nested level of the 
 design together with A-efficiency upper-bounds, where available.}
\item{seed}{Numerical seed used for random number generator.}
\item{searches}{Maximum number of searches used for each level.}
\item{jumps}{Number of random treatment swaps used to escape a local maxima.}
}
\description{
Constructs randomized nested blocks for unstructured treatment sets down to any feasible depth of nesting.
}
\details{
Constructs randomized nested block designs with arbitrary depth of nesting for any arbitrary number of unstructured
treatment sets.

\code{treatments} is a set of numbers partitioning the total number of treatments into
sets of equi-replicate treatments

\code{replicates} is a matching set of treatment replication numbers, one for each treatment 
set in the partition.

\code{blocks} is a set of levels where each number is the number of
levels nested within each level of the preceding factor. The top single level super-block
need not be defined.  
 
 The first number, if any, is the number of nested row blocks in the first-level of nesting, 
the second number, if any, is the number of nested row blocks in
the second-level of nesting and so on down to any required feasible depth of nesting.

Block sizes are as nearly equal as possible and will never differ by more than a single plot in any 
particular block classification. 

Unreplicated treatments are allowed and any simple nested block design can be augmented by any number 
of single unreplicated treatments to give augmented blocks that never differ in size by more than a single plot.
However, it may sometimes be preferable to find an efficient 
block design for the replicated treatments and then add the unreplicated treatments to the design heuristically. 

Square lattice designs are resolvable incomplete block designs for r replicates of p*p treatments 
arranged in blocks of size p where r < p+2 for prime or prime power p or r < 4 for general p. 
Square lattice designs are constructed algebraically from Latin squares or MOLS.

Rectangular lattice designs are resolvable incomplete block designs for r replicates of (p-1)*p treatments 
arranged in blocks of size p-1 where r < p+1 for prime or prime power p. Rectangular lattice designs are
constructed algebraically by reducing an algebraic square lattice, see 
Cochran and Cox, Experimental Designs. 2nd Edition. Page 417 (Shrikhande method).

Outputs:

\itemize{
\item  A data frame showing the allocation of treatments to blocks with successive nested strata arranged in standard block order.\cr
\item  A table showing the replication number of each treatment in the design. \cr
\item  A table showing the block levels and the achieved D-efficiency and A-efficiency factor for each nested level together
  with A-efficiency upper bounds, where available. \cr
\item  A plan showing the allocation of treatments to blocks in the bottom level of the design.\cr
}
}
\examples{

## The number of searches in the following examples have been limited for fast execution.  
## In practice, the number of searches may need to be increased for optimum results.
## Designs should be rebuilt several times to check that a near-optimum design has been found.  

# 12 treatments x 4 replicates in 4 complete blocks with 4 sub-blocks of size 3
# rectangular lattice see Plan 10.10 Cochran and Cox 1957.
\donttest{blocks(treatments=12,replicates=4,blocks=list(4,4))}

# 3 treatments x 2 replicates + 2 treatments x 4 replicates in two complete randomized blocks
blocks(treatments=list(3,2),replicates=list(2,4),blocks=2,searches=10)

# 50 treatments x 4 replicates with 4 main blocks and 5 nested sub-blocks in each main block
blocks(treatments=50,replicates=4,blocks=list(4,5))

# as above but with 20 additional single replicate treatments, one single treatment per sub-block
\donttest{blocks(treatments=list(50,20),replicates=list(4,1),blocks=list(4,5))}

# 6 replicates of 6 treatments in 4 blocks of size 9 (non-binary block design)
blocks(treatments=6,replicates=6,blocks=4)

# 128 treatments x 2 replicates with two main blocks and 3 levels of nesting
 \donttest{blocks(128,2,list(2,2,2,2))}

#' # 64 treatments x 4 replicates with 4 main blocks nested blocks of size 8 (lattice square)
blocks(64,4,list(4,8)) 

# 100 treatments x 4 replicates with 4 main blocks nested blocks of size 10 (lattice square)
blocks(100,4,list(4,10)) 

}
\references{
Cochran, W.G., and G.M. Cox. 1957. Experimental Designs, 2nd ed., Wiley, New York.
}
