% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots.R
\name{blr_plot_difchisq_fitted}
\alias{blr_plot_difchisq_fitted}
\title{Delta chi square vs fitted values plot}
\usage{
blr_plot_difchisq_fitted(model, point_color = "blue",
  title = "Delta Chi Square vs Fitted Values Plot",
  xaxis_title = "Fitted Values", yaxis_title = "Delta Chi Square")
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{point_color}{Color of the points.}

\item{title}{Title of the plot.}

\item{xaxis_title}{X axis label.}

\item{yaxis_title}{Y axis label.}
}
\description{
Delta Chi Square vs fitted values plot for detecting ill fitted observations.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_difchisq_fitted(model)

}
