% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_mcfadden}
\alias{blr_rsq_mcfadden}
\title{McFadden's R2}
\usage{
blr_rsq_mcfadden(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
McFadden's r-squared.
}
\description{
McFadden's pseudo r-squared for the model.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_mcfadden(model)

}
\references{
\url{https://eml.berkeley.edu/reprints/mcfadden/zarembka.pdf}
}
\concept{model fit statisitcs}
