% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-forward-selection.R
\name{blr_step_aic_forward}
\alias{blr_step_aic_forward}
\alias{blr_step_aic_forward.default}
\alias{plot.blr_step_aic_forward}
\title{Stepwise AIC forward selection}
\usage{
blr_step_aic_forward(model, ...)

\method{blr_step_aic_forward}{default}(model, progress = FALSE, details = FALSE, ...)

\method{plot}{blr_step_aic_forward}(x, text_size = 3, print_plot = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{...}{Other arguments.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{blr_step_aic_forward}.}

\item{text_size}{size of the text in the plot.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{blr_step_aic_forward} returns an object of class
\code{"blr_step_aic_forward"}. An object of class
\code{"blr_step_aic_forward"} is a list containing the following components:

\item{model}{model with the least AIC; an object of class \code{glm}}
\item{candidates}{candidate predictor variables}
\item{steps}{total number of steps}
\item{predictors}{variables entered into the model}
\item{aics}{akaike information criteria}
\item{bics}{bayesian information criteria}
\item{devs}{deviances}
}
\description{
Build regression model from a set of candidate predictor variables by
entering predictors based on chi square statistic, in a stepwise manner
until there is no variable left to enter any more.
}
\examples{
\dontrun{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

# selection summary
blr_step_aic_forward(model)

# print details of each step
blr_step_aic_forward(model, details = TRUE)

# plot
plot(blr_step_aic_forward(model))

# final model
k <- blr_step_aic_forward(model)
k$model

}

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other variable selection procedures: 
\code{\link{blr_step_aic_backward}()},
\code{\link{blr_step_aic_both}()},
\code{\link{blr_step_p_backward}()},
\code{\link{blr_step_p_forward}()}
}
\concept{variable selection procedures}
