% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/anb-bn-operate.R,
%   R/anb-bn.R
\name{inspect_bnc_bn}
\alias{inspect_bnc_bn}
\alias{nparams}
\alias{manb_arc_posterior}
\alias{awnb_weights}
\alias{params}
\alias{values}
\alias{classes}
\title{Inspect a Bayesian network classifier (with structure and parameters).}
\usage{
nparams(x)

manb_arc_posterior(x)

awnb_weights(x)

params(x)

values(x)

classes(x)
}
\arguments{
\item{x}{The \code{\link{bnc_bn}} object. The Bayesian network classifier.}
}
\description{
Functions for inspecting a \code{\link{bnc_bn}} object. In addition, you can 
query this object with the functions documented in 
\code{\link{inspect_bnc_dag}}.
}
\section{Functions}{
\itemize{
\item \code{nparams}: Returns the number of free parameters in the model.

\item \code{manb_arc_posterior}: Returns the posterior of each arc from the class
according to the MANB method.

\item \code{awnb_weights}: Returns the AWNB feature weights.

\item \code{params}: Returns the list of CPTs, in the same order as \code{\link{vars}}.

\item \code{values}: Returns the possible values of each variable, in the same order as \code{\link{vars}}.

\item \code{classes}: Returns the possible values of the class variable.
}}

\examples{
 
data(car)
nb <- bnc('nb', 'class', car, smooth = 1)
nparams(nb)
nb <- bnc('nb', 'class', car, smooth = 1, manb_prior = 0.5)
manb_arc_posterior(nb)
nb <- bnc('nb', 'class', car, smooth = 1, awnb_bootstrap = 0.5)
awnb_weights(nb)
}
