
#include <R.h>
#include <Rmath.h>
#include <R_ext/Applic.h>

static double _mi(int *nr, int *nc, int *nrowt, int *ncolt, 
        int n[][*nc], int *num) {

int i = 0, j = 0;
double mi = 0;

  for (i = 0; i < *nr; i++) 
    for (j = 0; j < *nc; j++) { 

      if (n[i][j] != 0)
        mi += ((double)n[i][j]) * 
                log((double)n[i][j]*(*num)/(nrowt[i]*ncolt[j]));

    }/*FOR*/

    mi = mi / (*num);

return mi;

}/*_MI*/

void mi(int *n, int *nr, int *nc, double *result) {

int nrowt[*nr], ncolt[*nc];
int num = 0;

union rc2 {

  int n[*nr][*nc];
  int m[(*nr)*(*nc)];

} urc;

  /* copy the original contingecy table to the buffer. */
  for (int k = 0; k < (*nr)*(*nc); k++)
    urc.m[k] = n[k];

  /* initialize row and column totals to zero. */
  memset(nrowt, '\0', sizeof(int)*(*nr));
  memset(ncolt, '\0', sizeof(int)*(*nc));

  /* compute row, column and global totals. */
  for (int i = 0; i < *nr; i++) {

    for (int j = 0; j < *nc; j++) {

      nrowt[i] += urc.n[i][j];
      ncolt[j] += urc.n[i][j];
      num += urc.n[i][j];

     }/*FOR*/

  }/*FOR*/

  *result = _mi(nr, nc, nrowt, ncolt, urc.n, &num);

}/*MI*/

void cmi (int *x, int *y, int *z, int *lx, int *ly, int *lz, int *length, double *result) {

  int i = 0, j = 0, k = 0;
  int n[*lx][*ly][*lz], ni[*lx][*lz], nj[*ly][*lz], nk[*lz];

  /* initialize result to zero. */
  *result = 0;

  /* initialize the contignecy table. */
  memset(n, '\0', sizeof(int)*(*lx)*(*ly)*(*lz));

  /* initialize the marginal frequencies. */
  memset(ni, '\0', sizeof(int)*(*lx)*(*lz));
  memset(nj, '\0', sizeof(int)*(*ly)*(*lz));
  memset(nk, '\0', sizeof(int)*(*lz));

  /* compute the joint frequency of x, y, and z. */
  for (k = 0; k < *length; k++) {

    n[x[k] - 1][y[k] - 1][z[k] - 1]++;
    ni[x[k] - 1][z[k] - 1]++;
    nj[y[k] - 1][z[k] - 1]++;
    nk[z[k] - 1]++;

  }/*FOR*/

  for (i = 0; i < *lx; i++)
    for (j = 0; j < *ly; j++)
      for (k = 0; k < *lz; k++) {

       if (n[i][j][k] != 0) {

          *result += (double)n[i][j][k] *
            log( (double)(n[i][j][k]*nk[k]) / (double)(ni[i][k]*nj[j][k]) );

        }/*THEN*/

      }/*FOR*/

   *result = *result/(*length);

}/*CMI*/

