% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.autocorr.diag}
\alias{network.autocorr.diag}
\title{Generate autocorrelation diagnostics using coda package}
\usage{
network.autocorr.diag(
  result,
  lags = c(0, 1, 5, 10, 50),
  extra.pars = NULL,
  only.pars = NULL
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{lags}{A vector of lags at which to calculate the autocorrelation}

\item{extra.pars}{Extra parameters that the user wants to display other than the default parameters.}

\item{only.pars}{Parameters that user wants to display. This gets rids of other default parameters user doesn't want to show.}
}
\value{
Returns autocorrelation diagnostics
}
\description{
This function generates autocorrelation diagnostics using coda package. User can specify lags and parameters to display. 
Note that to display extra parameters that are not saved, user needs to first specify parameters in \code{extra.pars.save} parameter in \code{\link{network.run}} function.
}
\examples{
network <- with(blocker, {
 network.data(Outcomes, Study, Treat, N = N, response = "binomial")
})
\donttest{
result <- network.run(network)
network.autocorr.diag(result, only.pars = "d")
}
}
