% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutualinfo.R
\name{mutual_info}
\alias{mutual_info}
\title{Mutual information}
\usage{
mutual_info(bnfit, node)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}

\item{node}{a node of \code{bnfit}.}
}
\value{
A dataframe with the following columns: \code{Nodes} - the vertices of the BN; \code{MutualInfo} - the mutual information of the corresponding node.
}
\description{
Computation of the mutual information in a Bayesian network
}
\details{
The mutual information between two variables \eqn{X_j} and \eqn{X_i} with sample spaces \eqn{\mathcal{X}_i} and \eqn{\mathcal{X}_j}, respectively, is equal to \deqn{\sum_{x_j\in\mathcal{X}_j}\sum_{x_i\in\mathcal{X}_i}p(x_i,x_j)\log\frac{p(x_i,x_j)}{p(x_i)p(x_j)}.}
}
\examples{
mutual_info(travel, "T")

}
\references{
Albrecht, D., Nicholson, A. E., & Whittle, C. (2014). Structural sensitivity for the knowledge engineering of Bayesian networks. In Probabilistic Graphical Models (pp. 1-16). Springer International Publishing.
}
\seealso{
\code{\link{ewi}}, \code{\link{dwi}}
}
