% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadNetwork.R
\name{loadNetwork}
\alias{loadNetwork}
\title{Load a Bayesian network}
\usage{
loadNetwork(network, target = NULL)
}
\arguments{
\item{network}{The Bayesian network. An object of class "grain" (package \href{https://cran.r-project.org/package=gRain}{gRain}), or a character (the path to the ".net" file to be imported)}

\item{target}{character. The node of interest to be modelled and mapped.}
}
\value{
An object of class "grain". The Bayesian network. If \code{target} argument is provided the network is compiled for a faster querying .
}
\description{
This function loads the Bayesian network from a native gRain object of class "grain" or an external file with extension .net (as provided from Hugin or GeNIe), then compiles the network if a target node of interest is given.
}
\details{
Bayesian networks from the package "bnlearn" can be imported via the function 
".net" file format as provided from Netica currently does not correspond to a valid Hugin .net file.\cr
Argument \code{target} has default set to NULL, but if provided the network will be compiled based on it for faster querying.
}
\examples{
## Load from external file (.net format)
raw = system.file("extdata/LandUseChange.net", package = "bnspatial")
loadNetwork(raw)

## Compile using target node
loadNetwork(raw, 'FinalLULC')
}

