% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strength.viewer.R
\name{strength.viewer}
\alias{strength.viewer}
\title{Interactive Bayesian Network Strength Viewer}
\usage{
strength.viewer(bayesianNetwork, bayesianNetwork.background = NULL,
  bayesianNetwork.boot.strength = NULL,
  bayesianNetwork.arc.strength.threshold.expression = NULL,
  bayesianNetwork.arc.strength.threshold.expression.color = NULL,
  bayesianNetwork.arc.strength.threshold.alternative.color = NULL,
  bayesianNetwork.arc.strength.label = FALSE,
  bayesianNetwork.arc.strength.label.prefix = "",
  bayesianNetwork.arc.strength.label.color = NULL,
  bayesianNetwork.arc.strength.tooltip = FALSE,
  bayesianNetwork.edge.scale.min = 1,
  bayesianNetwork.edge.scale.max = 5,
  bayesianNetwork.edge.scale.label.min = 14,
  bayesianNetwork.edge.scale.label.max = 14,
  bayesianNetwork.title = "", bayesianNetwork.subtitle = "",
  bayesianNetwork.footer = "", bayesianNetwork.layout = "default",
  bayesianNetwork.width = "100\%", bayesianNetwork.height = "500px",
  node.shape = c("dot"), node.label.prefix = "",
  node.colors = list(), node.font = list(), edges.smooth = TRUE,
  edges.dashes = FALSE, edges.colors = list(),
  options.highlightNearest = TRUE, options.nodesIdSelection = FALSE)
}
\arguments{
\item{bayesianNetwork}{A Bayesian Network structure from Averaged Network}

\item{bayesianNetwork.background}{Bayesian network background}

\item{bayesianNetwork.boot.strength}{A nonparametric bootstrap to assess arc strength and direction}

\item{bayesianNetwork.arc.strength.threshold.expression}{Logical expression of the force threshold of the arcs of the Bayesian network}

\item{bayesianNetwork.arc.strength.threshold.expression.color}{Color applied to logical expression of the force threshold of the arcs of the Bayesian network}

\item{bayesianNetwork.arc.strength.threshold.alternative.color}{Alternative color to logical expression of the force threshold of the arcs of the Bayesian network}

\item{bayesianNetwork.arc.strength.label}{Enable Bayesian Network arc strength label}

\item{bayesianNetwork.arc.strength.label.prefix}{Include Bayesian Network arc strength label prefix}

\item{bayesianNetwork.arc.strength.label.color}{Set Bayesian Network arc strength label color}

\item{bayesianNetwork.arc.strength.tooltip}{Enable Bayesian Network arc strength tooltip}

\item{bayesianNetwork.edge.scale.min}{Set bayesian Network edge scale minimum}

\item{bayesianNetwork.edge.scale.max}{Set bayesian Network edge scale maximum}

\item{bayesianNetwork.edge.scale.label.min}{Set bayesian Network edge scale label minimum}

\item{bayesianNetwork.edge.scale.label.max}{Set bayesian Network edge scale label maximum}

\item{bayesianNetwork.title}{: String. Bayesian Network title}

\item{bayesianNetwork.subtitle}{: String. Bayesian Network subtitle}

\item{bayesianNetwork.footer}{: String. Bayesian Network footer}

\item{bayesianNetwork.layout}{: String. A layout of a Bayesian Network
\enumerate{
  \item layout_on_sphere
  \item layout_on_grid
  \item layout_in_circle
  \item layout_as_star
  \item layout_as_tree
  \item layout_with_sugiyama
  \item layout_with_kk
  \item layout_with_dh
  \item layout_with_lgl
  \item layout_with_mds
  \item layout_with_gem
  \item layout_nicely
  \item layout_components
}}

\item{bayesianNetwork.width}{: String. Bayesian Network width}

\item{bayesianNetwork.height}{: String. Bayesian Network height}

\item{node.shape}{: String. A node shape of a Bayesian Network
\enumerate{
  \item dot (default)
  \item circle
  \item ellipse
  \item database
  \item diamond
  \item square
  \item triangle
  \item box
  \item star
  \item text
}}

\item{node.label.prefix}{: String. Adds a prefix to the node label}

\item{node.colors}{: String | named list. Color for the node. Can be 'rgba(120,32,14,1)', '#97C2FC'
(hexa notation on 7 char without transparency) or 'red'.
Can be just one color, or a list with several elements:

\enumerate{
  \item "background" : String. Default to '#97C2FC'. Background color for the node.
  \item "border" : String. Default to '#2B7CE9'. Border color for the node.
  \item "highlight" : String | named list, Color of the node when selected.
  \enumerate{
     \item "background" : String. Default to '#97C2FC'. Background color for the node when selected.
     \item "border" : String. Default to '#2B7CE9'. Border color for the node when selected.
  }
}}

\item{node.font}{Node Font : Array. Example list(color = "black", face="Arial")}

\item{edges.smooth}{: Boolean. When true, the edge is drawn as a dynamic quadratic bezier curve.}

\item{edges.dashes}{: Array or Boolean. Default to false. When true, the edge will be drawn as a dashed line.}

\item{edges.colors}{: Named list or String. Default to named list. Color information of the edge in every situation. Can be 'rgba(120,32,14,1)', '#97C2FC' (hexa notation on 7 char without transparency) or 'red'.

 \itemize{
 \item{"color"}{ : String. Default to '#848484. The color of the edge when it is not selected or hovered over (assuming hover is enabled in the interaction module).}
 \item{"highlight "}{ : String. Default to '#848484'. The color the edge when it is selected.}
 \item{"hover"}{ : String. Default to '#848484'. The color the edge when the mouse hovers over it (assuming hover is enabled in the interaction module).}
 \item{"inherit"}{ : String or Boolean. Default to 'from'. When color, highlight or hover are defined, inherit is set to false! Supported options are: true, false, 'from','to','both'.}
 \item{"opacity"}{ : Number. Default to 1.0. It can be useful to set the opacity of an edge without manually changing all the colors. The allowed range of the opacity option is between 0 and 1.}
}}

\item{options.highlightNearest}{: Boolean. Default to true. Highlight nearest when clicking a node.}

\item{options.nodesIdSelection}{: Boolean. Default to false. Add an id node selection creating an HTML select element.}
}
\description{
Show the strength of the probabilistic relationships expressed by the arcs of
a Bayesian network, and use model averaging to build a network containing only
the significant arcs.
}
\examples{

library(bnlearn)
library(bnviewer)

bayesianNetwork.boot.strength = boot.strength(coronary, R = 20, algorithm = "hc")

avg.bayesianNetwork = averaged.network(bayesianNetwork.boot.strength, threshold = 0.2)

strength.viewer(
  avg.bayesianNetwork,
  bayesianNetwork.boot.strength,
  bayesianNetwork.background = "white",
  bayesianNetwork.arc.strength.threshold.expression = c("@threshold > 0 & @threshold < 0.5",
                                                        "@threshold >= 0.5 & @threshold < 0.6",
                                                        "@threshold >= 0.6 & @threshold <= 1"),

  bayesianNetwork.arc.strength.threshold.expression.color  = c("red", "yellow", "green"),
  bayesianNetwork.arc.strength.threshold.alternative.color =  "white",

  bayesianNetwork.arc.strength.label = TRUE,
  bayesianNetwork.arc.strength.label.prefix = "",
  bayesianNetwork.arc.strength.label.color = "black",

  bayesianNetwork.arc.strength.tooltip = TRUE,

  bayesianNetwork.edge.scale.min = 1,
  bayesianNetwork.edge.scale.max = 3,

  bayesianNetwork.edge.scale.label.min = 14,
  bayesianNetwork.edge.scale.label.max = 14,

  bayesianNetwork.width = "100\%",
  bayesianNetwork.height = "800px",
  bayesianNetwork.layout = "layout_with_sugiyama",
  node.colors = list(background = "#97c2fc",
                     border = "#2b7ce9",
                     highlight = list(background = "#e91eba",
                                      border = "#2b7ce9")),

  node.font = list(color = "black", face="Arial"),
  edges.dashes = FALSE,

  bayesianNetwork.title="Bayesian Network Strength Analysis - Coronary",
  bayesianNetwork.subtitle = "Coronary heart disease data set",
  bayesianNetwork.footer = "Fig. 1 - Layout with Sugiyama"
)

}
\references{
See online documentation \url{http://robsonfernandes.net/bnviewer}
}
