% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_satellite_imagery.R
\name{get_available_imagery}
\alias{get_available_imagery}
\title{Get a Listing of Available BOM Satellite GeoTIFF Imagery}
\usage{
get_available_imagery(product_id = "all")
}
\arguments{
\item{product_id}{Character.  BOM product ID of interest for which a list of
available images will be returned.  Defaults to all images currently
available.}
}
\value{
A vector of all available files for the requested Product ID(s).
}
\description{
Fetch a listing of BOM GeoTIFF satellite imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/gms/} to determine which files are
currently available for download.  Files are available at ten minute update
frequency with a 24 hour delete time.  Useful to know the most recent files
available and then specify in the \code{\link{get_satellite_imagery}}
function.
}
\details{
Valid BOM satellite Product IDs for GeoTIFF files include:
\describe{
\item{IDE00420}{AHI cloud cover only 2km FD GEOS GIS}
\item{IDE00421}{AHI IR (Ch13) greyscale 2km FD GEOS GIS}
\item{IDE00422}{AHI VIS (Ch3) greyscale 2km FD GEOS GIS}
\item{IDE00423}{AHI IR (Ch13) Zehr 2km FD GEOS GIS}
\item{IDE00425}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km FD
GEOS GIS}
\item{IDE00426}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km FD
GEOS GIS}
\item{IDE00427}{AHI WV (Ch8) 2km FD GEOS GIS}
\item{IDE00430}{AHI cloud cover only 2km AUS equirect. GIS}
\item{IDE00431}{AHI IR (Ch13) greyscale 2km AUS equirect. GIS}
\item{IDE00432}{AHI VIS (Ch3) greyscale 2km AUS equirect. GIS}
\item{IDE00433}{AHI IR (Ch13) Zehr 2km AUS equirect. GIS}
\item{IDE00435}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km AUS
equirect. GIS}
\item{IDE00436}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km AUS
equirect. GIS}
\item{IDE00437}{AHI WV (Ch8) 2km AUS equirect. GIS}
\item{IDE00439}{AHI VIS (Ch3) greyscale 0.5km AUS equirect. GIS}
}
}
\examples{
\dontrun{
Check availability of AHI VIS (true colour) / IR (Ch13 greyscale) composite
1km FD GEOS GIS images
imagery <- get_available_imagery(product_id = "IDE00425")
}

}
\references{
Australian Bureau of Meteorology (BOM) High-definition satellite images
\url{http://www.bom.gov.au/australia/satellite/index.shtml}
}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com}
}
