% Please edit documentation in R/utils.R
\name{serve_book}
\alias{serve_book}
\title{Continously preview the HTML output of a book using the \pkg{servr} package}
\usage{
serve_book(dir = ".", output_dir = "_book", preview = TRUE, in_session = TRUE, 
    daemon = FALSE, ...)
}
\arguments{
\item{dir}{The root directory of the book (containing the Rmd source files).}

\item{output_dir}{The directory for output files; see
\code{\link{render_book}()}.}

\item{preview}{Whether to render the modified/added chapters only, or the
whole book; see \code{\link{render_book}()}.}

\item{in_session}{Whether to compile the book using the current R session, or
always open a new R session to compile the book whenever changes occur in
the book directory.}

\item{daemon, ...}{Other arguments passed to \code{servr::\link[servr]{httw}()} (not
including the \code{handler} argument, which has been set internally).}
}
\description{
When any files are modified or added to the book directory, the book will be
automatically recompiled, and the current HTML page in the browser will be
refreshed. This function is based on \code{servr::\link[servr]{httw}()} to
continuously watch a directory.
}
\details{
For \code{in_session = TRUE}, you will have access to all objects created in
the book in the current R session: if you use a daemonized server (via the
argument \code{daemon = TRUE}), you can check the objects at any time when
the current R session is not busy; otherwise you will have to stop the server
before you can check the objects. This can be useful when you need to
interactively explore the R objects in the book. The downside of
\code{in_session = TRUE} is that the output may be different with the book
compiled from a fresh R session, because the state of the current R session
may not be clean.

For \code{in_sesion = FALSE}, you do not have access to objects in the book
from the current R session, but the output is more likely to be reproducible
since everything is created from new R sessions. Since this function is only
for previewing purposes, the cleanness of the R session may not be a big
concern. You may choose \code{in_session = TRUE} or \code{FALSE} depending on
your specific applications. Eventually, you should run \code{render_book()}
from a fresh R session to generate a reliable copy of the book output.
}
