% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extreme_value_distribution.R
\name{extreme_value_distribution}
\alias{extreme_value_distribution}
\alias{extreme_value_pdf}
\alias{extreme_value_lpdf}
\alias{extreme_value_cdf}
\alias{extreme_value_lcdf}
\alias{extreme_value_quantile}
\title{Extreme Value Distribution Functions}
\usage{
extreme_value_pdf(x, location = 0, scale = 1)

extreme_value_lpdf(x, location = 0, scale = 1)

extreme_value_cdf(x, location = 0, scale = 1)

extreme_value_lcdf(x, location = 0, scale = 1)

extreme_value_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Extreme Value distribution.
}
\examples{
# Extreme Value distribution with location = 0, scale = 1
extreme_value_pdf(0)
extreme_value_lpdf(0)
extreme_value_cdf(0)
extreme_value_lcdf(0)
extreme_value_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/extreme_dist.html}{Boost Documentation} for more details on the mathematical background.
}
