% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomials.R
\name{spherical_harmonics}
\alias{spherical_harmonics}
\alias{spherical_harmonic}
\alias{spherical_harmonic_r}
\alias{spherical_harmonic_i}
\title{Spherical Harmonics}
\usage{
spherical_harmonic(n, m, theta, phi)

spherical_harmonic_r(n, m, theta, phi)

spherical_harmonic_i(n, m, theta, phi)
}
\arguments{
\item{n}{Degree of the spherical harmonic}

\item{m}{Order of the spherical harmonic}

\item{theta}{Polar angle (colatitude)}

\item{phi}{Azimuthal angle (longitude)}
}
\value{
A single complex value with the computed spherical harmonic function, or its real and imaginary parts.
}
\description{
Functions to compute spherical harmonics and related functions.
}
\examples{
# Spherical harmonic function Y_2^1(0.5, 0.5)
spherical_harmonic(2, 1, 0.5, 0.5)
# Real part of the spherical harmonic function Y_2^1(0.5, 0.5)
spherical_harmonic_r(2, 1, 0.5, 0.5)
# Imaginary part of the spherical harmonic function Y_2^1(0.5, 0.5)
spherical_harmonic_i(2, 1, 0.5, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/sf_poly/sph_harm.html}{Boost Documentation}
}
