% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauchy_distribution.R
\name{cauchy_distribution}
\alias{cauchy_distribution}
\alias{cauchy_pdf}
\alias{cauchy_lpdf}
\alias{cauchy_cdf}
\alias{cauchy_lcdf}
\alias{cauchy_quantile}
\title{Cauchy Distribution Functions}
\usage{
cauchy_distribution(location = 0, scale = 1)

cauchy_pdf(x, location = 0, scale = 1)

cauchy_lpdf(x, location = 0, scale = 1)

cauchy_cdf(x, location = 0, scale = 1)

cauchy_lcdf(x, location = 0, scale = 1)

cauchy_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Cauchy distribution.
}
\examples{
# Cauchy distribution with location = 0, scale = 1
dist <- cauchy_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
support(dist)

# Convenience functions
cauchy_pdf(0)
cauchy_lpdf(0)
cauchy_cdf(0)
cauchy_lcdf(0)
cauchy_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/cauchy_dist.html}{Boost Documentation} for more details on the mathematical background.
}
