% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_of_integration.R
\name{plot_order_integration}
\alias{plot_order_integration}
\title{Plot Orders of Integration}
\usage{
plot_order_integration(orders, show_names = TRUE, show_legend = TRUE,
  names_size = NULL, legend_size = NULL, cols = NULL)
}
\arguments{
\item{orders}{A \code{"bootUR", "order_integration"} object obtained from the function \code{order_integration}, or a vector with found orders of integration.}

\item{show_names}{Show the time series' names on the plot (\code{TRUE}) or not (\code{FALSE}). Default is \code{TRUE}.}

\item{show_legend}{Logical indicator whether a legend should be displayed. Default is \code{TRUE}.}

\item{names_size}{Size of the time series' names if \code{show_names = TRUE}. Default takes \code{ggplot2} defaults.}

\item{legend_size}{Size of the text in the legend if \code{show_legend = TRUE}. Default takes \code{ggplot2} defaults.}

\item{cols}{Vector with colours for displaying the orders of integration. At least as many colours as orders of integration need to be supplied. Default supplies 4 colours for displaying up to \eqn{I(3)} series.}
}
\value{
A \code{ggplot2} object containing the plot of the orders of integration.
}
\description{
Plots a vector with orders of integration of time series.
}
\details{
This function requires the package \code{ggplot2} to be installed. If the package is not found, plotting is aborted.
}
\seealso{
\code{\link{order_integration}}
}
