% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{logistic}
\alias{logistic}
\title{Apply a custom logisitic transform to a vector}
\usage{
logistic(x, lower = 0, upper = 1, rate = 0.04, skew = 0.2, shift = 0,
  parms = NULL)
}
\arguments{
\item{x}{\code{vector} or \code{raster*} object to apply logistic transform.}

\item{lower}{The lower asymptote}

\item{upper}{The upper asymptote}

\item{rate}{The rate of decay.
A rate of 0 indicates no decay, while large rates (>10) become like step-functions.}

\item{skew}{Affects near which asymptote maximum rate (\code{skew} must be >0).
If skew=1, the curve becomes a standard symetrical logistic centered at \code{m}.    
As skew approaches zero, it becomes more asymetrical.}

\item{shift}{The time of maximum decay. Slides the curve left-right.}

\item{parms}{an optional list with each of the following named parameters
(e.g. \code{list(lower=0.01,upper=1,rate=0.04,skew=0.2,shift=0)}).
Use of \code{parms} rather than naming each parameter separately is for
convenience with the \code{\link{optim}} function.}
}
\description{
Performs a generalized logistic transform (aka Richard's curve) as follows:
 \deqn{Y(t) = upper - { upper-lower \over (1 + e^{-rate(x - shift)}) ^ {1 / skew} }}{y=upper-(upper-lower)/((1+exp(-rate*(x-shift)))^(1/skew))}
}
\examples{
curve(logistic(x,rate=0.05,skew=0.5),-150,300)
}
\references{
Richards, F. J. (1959). 'A Flexible Growth Function for Empirical Use'. 
Journal of Experimental Botany 10 (2): 290-300.
}

