% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis.R
\name{kinesis_put_record}
\alias{kinesis_put_record}
\title{Writes a single data record into an Amazon Kinesis data stream}
\usage{
kinesis_put_record(stream, data, partition_key)
}
\arguments{
\item{stream}{the name of the stream to describe}

\item{data}{the data blob (<1 MB) to put into the record, which is base64-encoded when the blob is serialized}

\item{partition_key}{Unicode string with a maximum length limit of 256 characters determining which shard in the stream the data record is assigned to}

\item{...}{optional further parameters that might be required for some of the above parameter combinations}
}
\value{
list of \code{ShardId}, \code{SequenceNumber} and \code{EncryptionType}
}
\description{
Writes a single data record into an Amazon Kinesis data stream
}
\references{
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/kinesis.html#Kinesis.Client.put_record}
}
