% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxCoxmix.R, R/summary.boxcoxmix.R
\name{np.estep}
\alias{np.estep}
\alias{np.zk}
\alias{fik}
\alias{np.theta}
\alias{yhat}
\alias{ytrans}
\alias{np.bhat}
\alias{np.mstep}
\alias{np.em}
\alias{np.boxcox}
\alias{vc.estep}
\alias{zk}
\alias{bhat}
\alias{mik}
\alias{vc.theta}
\alias{vc.mstep}
\alias{vc.em}
\alias{vc.boxcox}
\alias{nb.se}
\alias{vc.se}
\alias{gqz}
\alias{masspoint.class}
\title{Internal boxcoxmix functions}
\usage{
np.estep(y, x, lambda, p, beta, z, sigma)

np.zk(y, x, w, beta, lambda)

fik(y, x, lambda, beta, z, sigma)

np.theta(y, x, lambda, beta, z)

yhat(v, lambda = 1)

ytrans(y, lambda = 1)

np.bhat(y, x, w, z, lambda)

np.mstep(y, x, beta, lambda, w)

np.em(
  y,
  x,
  K,
  lambda = 1,
  steps = 500,
  tol = 0.5,
  start = "gq",
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  ...
)

np.boxcox(
  formula,
  groups = 1,
  data,
  K = 3,
  tol = 0.5,
  lambda = 1,
  steps = 500,
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  start = "gq",
  ...
)

vc.estep(Y, X, sizes = 1, lambda, p, beta, z, sigma)

zk(Y, X, sizes, w, beta, lambda)

bhat(Y, X, sizes, w, z, lambda)

mik(Y, X, sizes, lambda, beta, z, sigma)

vc.theta(Y, X, sizes, lambda, beta, z)

vc.mstep(Y, X, sizes = 1, beta, lambda, w)

vc.em(
  y,
  x,
  sizes = 1,
  K,
  lambda,
  steps = 500,
  tol = 0.5,
  start = "gq",
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  ...
)

vc.boxcox(
  formula,
  groups = 1,
  data,
  K = 3,
  tol = 0.5,
  lambda = 1,
  steps = 500,
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  start = "gq",
  ...
)

gqz(numnodes = 20, minweight = 1e-06)

masspoint.class(object)
}
\arguments{
\item{y}{..}

\item{x}{..}

\item{lambda}{a transformation parameter, setting \code{lambda}=1 means 'no
transformation'.}

\item{p}{..}

\item{beta}{..}

\item{z}{..}

\item{sigma}{..}

\item{w}{..}

\item{v}{..}

\item{K}{the number of mass points.}

\item{steps}{maximum number of iterations for the EM algorithm.}

\item{tol}{a positive scalar (usually, 0< \code{tol} <= 2)}

\item{start}{a description of the initial values to be used in the fitted
model, Quantile-based version "quantile" or Gaussian Quadrature "gq" can be
set.}

\item{EMdev.change}{a small scalar, with default 0.0001, used to determine
when to stop EM algorithm.}

\item{plot.opt}{Set plot.opt=1, to plot the disparity against
iteration number. Use \code{plot.opt=2} for \code{tolfind.boxcox} and \code{plot.opt=3}
for \code{optim.boxcox}.}

\item{verbose}{If set to FALSE, no printed output on progress.}

\item{\dots}{extra arguments will be ignored.}

\item{formula}{a formula describing the transformed response and the fixed
effect model (e.g. y ~ x).}

\item{groups}{the random effects. To fit overdispersion models , set \code{groups} = 1.}

\item{data}{a data frame containing variables used in the fixed and random
effect models.}

\item{Y}{..}

\item{X}{..}

\item{sizes}{..}

\item{numnodes}{..}

\item{minweight}{..}

\item{object}{..}
}
\description{
auxiliary functions are not intended to be directly called from the user.
}
\details{
Internal boxcoxmix functions
}
\author{
Amani Almohaimeed and Jochen Einbeck
}
\keyword{em}
