% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGMMmain.R
\name{parsimoniousGaussianMixtureModel}
\alias{parsimoniousGaussianMixtureModel}
\title{bpgmm Model-Based Clustering Using Baysian PGMM Carries out model-based clustering using parsimonious Gaussian mixture models. MCMC are used for parameter estimation. The RJMCMC is used for model selection.}
\usage{
parsimoniousGaussianMixtureModel(niter, burn, X, n, p, delta, ggamma, m,
  qVec, qnew, constraint, dVec, sVec)
}
\arguments{
\item{niter}{the number of iterations}

\item{burn}{the number of burn in iterations}

\item{X}{the observation matrix with size p * m}

\item{n}{the number of observations}

\item{p}{the number of features}

\item{delta}{scaler hyperparameters}

\item{ggamma}{scaler hyperparameters}

\item{m}{the number of clusters}

\item{qVec}{the vector of the number of factors in each clusters}

\item{qnew}{the number of factor for a new cluster}

\item{constraint}{the pgmm constraint, a vector of length three with binary entry. For example, c(1,1,1) means the fully constraint model}

\item{dVec}{a vector of hyperparameters with length three, shape parameters for alpha1, alpha2 and bbeta respectively}

\item{sVec}{a vector of hyperparameters with length three, rate parameters for alpha1, alpha2 and bbeta respectively}
}
\value{
parsimonious Gaussian mixture models classification results list
}
\description{
bpgmm Model-Based Clustering Using Baysian PGMM Carries out model-based clustering using parsimonious Gaussian mixture models. MCMC are used for parameter estimation. The RJMCMC is used for model selection.
}
\examples{
sample_data = "https://raw.githubusercontent.com/lzyacht/bpgmm-examples/master/data/sampleData.csv"
X = utils::read.table(sample_data, header = TRUE, sep = ',')
X = as.matrix(X)
nsim = 1
burn = 20
n = ncol(X)
p = nrow(X)
m = 2
qVec = rep(3,m)
qnew = 3
delta = 2
ggamma = 2
dVec = c(1,1,1)
sVec = c(1,1,1)
constraint = c(0,0,0)
\donttest{
parsimoniousGaussianMixtureModel(nsim,burn,X,n,p,delta,ggamma,m,qVec,qnew,constraint,dVec,sVec)
}


}
