% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpmnVisualizationR.R
\name{display}
\alias{display}
\title{Display 'BPMN' diagram in an 'HTML' Widget}
\usage{
display(
  bpmnXML,
  overlays = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{bpmnXML}{A file name or 'XML' document or string in 'BPMN' 'XML' format}

\item{overlays}{An element or a list of elements to be added to the diagram's existing elements.
Use overlay function to create an overlay object with content and relative position.}

\item{width}{Fixed width for widget (in css units). The default is \code{NULL}, which results in intelligent automatic sizing based on the widget's container.}

\item{height}{Fixed height for widget (in css units). The default is \code{NULL}, which results in intelligent automatic sizing based on the widget's container.}

\item{elementId}{The id of the 'HTML' element to enclose the widget.
Use an explicit element ID for the widget (rather than an automatically
generated one). Useful if you have other 'JavaScript' that needs to explicitly
discover and interact with a specific widget instance.}
}
\value{
A \code{bpmnVisualizationR} Widget that will intelligently print itself into 'HTML' in a variety of contexts
     including the 'R' console, within 'R Markdown' documents, and within 'Shiny' output bindings.
}
\description{
Display 'BPMN' diagram based on 'BPMN' definition in 'XML' format
}
\examples{
# Load the BPMN file
bpmn_file <- system.file("examples/Order_Management.bpmn", package = "bpmnVisualizationR")

# Display the BPMN diagram
bpmnVisualizationR::display(bpmn_file, width='auto', height='auto')

# Display the BPMN diagram with overlays
overlays <- list(
  bpmnVisualizationR::create_overlay("start_event_1_1", "42"),
  bpmnVisualizationR::create_overlay("sequence_flow_1_1", "42"),
  bpmnVisualizationR::create_overlay("task_1_1", "9")
)
bpmnVisualizationR::display(bpmn_file, overlays, width='auto', height='auto')

}
\seealso{
\code{\link{create_overlay}} to create an overlay
}
