% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{inefficiency_factorg3}
\alias{inefficiency_factorg3}
\title{Inefficiency Factor for Ordinal Models
with more than 3 outcomes}
\usage{
inefficiency_factorg3(beta_draws, nlags = 2, delta_draws)
}
\arguments{
\item{beta_draws}{Gibbs draw of coeffcients of dimension \eqn{(k x iter)}.}

\item{nlags}{scalar variable with default = 2.}

\item{delta_draws}{Gibbs draw of cut-points.}
}
\value{
Returns a list with components
\itemize{
\item{\code{inefficiency_delta}: }{a vector with inefficiency factor for each \eqn{\delta}.}
\item{\code{inefficiency_beta}: }{a vector with inefficiency facor for each \eqn{\beta}.}
}
}
\description{
This function calculates the inefficiency factor from the MCMC draws
of \eqn{(\beta, \delta)} for an ordinal model with more than 3 outcomes. The
inefficiency factor is calculated using the batch-means method.
}
\details{
Calculates the inefficiency factor of \eqn{(\beta, \delta)} using the batch-means
method.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
ans <- quan_regg3(y, x, mc = 50, p, 0.1)
beta_draws <- ans$beta_draws
delta_draws <- ans$delta_draws
nlags = 2
inefficiency <- inefficiency_factorg3(beta_draws, nlags, delta_draws)

# inefficiency_delta
#   1.433599
#   1.426150
# inefficiency_beta
#   0.6035289
#   1.2967271
#   1.2751728

}
\references{
Greenberg, E. (2012). “Introduction to Bayesian Econometrics.” Cambridge University
Press, Cambridge.
}
\seealso{
pracma
}
