% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{trace_plot3}
\alias{trace_plot3}
\title{Trace Plots for Ordinal Models
with 3 outcomes}
\usage{
trace_plot3(beta_draws, sigma_draws)
}
\arguments{
\item{beta_draws}{Gibbs draw of \eqn{\beta} vector of dimension \eqn{(k x iter)}.}

\item{sigma_draws}{Gibbs draw of scale parameter, \eqn{\sigma}.}
}
\value{
Returns trace plots for each element of \eqn{\beta} and \eqn{\sigma}.
}
\description{
This function generates trace plots of
MCMC samples for \eqn{(\beta ,\sigma)} in the quantile
regression model with 3 outcomes.
}
\details{
Trace plot is a visual depiction of the values generated from the Markov chain
versus the iteration number.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
p <- 0.25
ans <- quan_reg3(y, x, mc = 50, p)
beta_draws <- ans$beta_draws
sigma_draws <- ans$sigma_draws
trace_plot3(beta_draws, sigma_draws)

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
traces in MCMC simulations
}
