% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{deviance_or2}
\alias{deviance_or2}
\title{Deviance Information Criteria for Ordinal Model
with 3 outcomes}
\usage{
deviance_or2(
  y,
  x,
  gammacp,
  p,
  postMeanbeta,
  postStdbeta,
  postMeansigma,
  postStdsigma,
  beta,
  sigma,
  burn,
  nsim
)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{gammacp}{row vector of cut-points including -Inf and Inf.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{postMeanbeta}{mean value of \eqn{\beta} obtained from MCMC draws.}

\item{postStdbeta}{standard deviation of \eqn{\beta} obtained from MCMC draws.}

\item{postMeansigma}{mean value of \eqn{\sigma} obtained from MCMC draws.}

\item{postStdsigma}{standard deviation of \eqn{\sigma} obtained from MCMC draws.}

\item{beta}{MCMC draw of coefficients, dimension is \eqn{(k x nsim)}.}

\item{sigma}{MCMC draw of scale factor, dimension is \eqn{(nsim x 1)}.}

\item{burn}{number of discarded MCMC iterations.}

\item{nsim}{total number of MCMC iterations including the burn-in.}
}
\value{
Returns a list with components
\deqn{DIC = 2*avgdeviance - devpostmean}
\deqn{pd = avgdeviance - devpostmean}
\deqn{devpostmean = -2*(logLikelihood)}.
}
\description{
Function for computing the Deviance information criteria for ordinal
model with 3 outcomes.
}
\details{
The deviance is -2*(log likelihood) and has an important role in
statistical model comparison because of its relation with Kullback-Leibler
information criteria.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y = y, x = x, B0 = 10*diag(k),
mcmc = 50, p = 0.25)
gammacp <- c(-Inf, 0, 3, Inf)
postMeanbeta <- output$postMeanbeta
postStdbeta <- output$postStdbeta
postMeansigma <- output$postMeansigma
postStdsigma <- output$postStdsigma
beta <- output$beta
sigma <- output$sigma
mcmc = 50
burn <- 10
nsim <- burn + mcmc
deviance <- deviance_or2(y, x, gammacp, p = 0.25, postMeanbeta, postStdbeta,
postMeansigma, postStdsigma, beta, sigma, burn, nsim)

# DIC
#   779.4566
# pd
#   5.233374
# devpostmean
#   768.9898

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Spiegelhalter, D. J., Best, N. G., Carlin B. P. and Linde A. (2002).
“Bayesian Measures of Model Complexity and Fit.” Journal of the
Royal Statistical Society B, Part 4: 583-639.

Gelman, A., Carlin, J. B., Stern, H. S., and Rubin, D. B.
“Bayesian Data Analysis.” 2nd Edition, Chapman and Hall.
}
\seealso{
decision criteria
}
