% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{alcdf}
\alias{alcdf}
\title{cdf of an asymmetric Laplace distribution}
\usage{
alcdf(x, mu, sigma, p)
}
\arguments{
\item{x}{scalar value.}

\item{mu}{location parameter of AL distribution.}

\item{sigma}{scale parameter of AL distribution.}

\item{p}{quantile or skewness parameter, p in (0,1).}
}
\value{
Returns the cumulative probability value at
point “x”.
}
\description{
This function computes the cumulative distribution function (cdf) of
an asymmetric Laplace (AL) distribution.
}
\details{
Computes the cdf of
an AL distribution.
\deqn{CDF(x) = F(x) = P(X \le x)} where X is a
random variable that follows AL(\eqn{\mu}, \eqn{\sigma}, p)
}
\examples{
set.seed(101)
x <- -0.5428573
mu <- 0.5
sigma <- 1
p <- 0.25
output <- alcdf(x, mu, sigma, p)

# output
#   0.1143562

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Yu, K., and Zhang, J. (2005). “A Three-Parameter Asymmetric
Laplace Distribution.” Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
}
\seealso{
cumulative distribution function, asymmetric Laplace distribution
}
